<?php defined('PF_VERSION') OR exit('Access denied'); ?>
<?php
define('PLUGIN_FAQ', __('FAQs', 'faq'));
class Faq_Plugin extends Pf_Plugin
{

    public $name = PLUGIN_FAQ;
    public $version = '1.0';
    public $author = 'PageFlex Team';
    public $description = 'This is the page description';

    public function activate()
    {
        $db = Pf::database();
//        $acl = Pf::acl();
//
//        $acl->add_plugin_permission('faq', 'Manage FAQ', array(
//            'view'=>'View',
//            'create'=>'Create',
//            'edit'=>'Edit',
//            'status'=>'Status',
//            'delete'=>'Delete'
//        ));
        $count = $db->dcount('*', 'pf_options', "`option_name`='faq'");
        if ($count == 0) {
            $sql = "INSERT INTO `pf_options` ( `option_name`, `option_value`) VALUES ('faq', '')";
            $db->query($sql);
        }
    }

    public function deactivate()
    {
//        $acl = Pf::acl();
//        $acl->delete_plugin_permission('faq');
    }

    public function admin_init()
    {
        require ABSPATH . '/includes/common/plugin/helpers/permission.php';
//        $show = Pf::acl()->check_access('faq', 'view');
//        $this->admin_menu('fa fa-question-circle', __('FAQs', 'faq'), 'faq', 'plugin_faq_manager',$show);
        $this->admin_menu('fa fa-question-circle', __('FAQs', 'faq'), 'faq', 'plugin_faq_manager');
    }

    function plugin_faq_manager()
    {
        $this->js('admin/themes/default/assets/bootstrap-notification/js/jquery/jquery.easing.1.3.js');
        $this->js('admin/themes/default/assets/bootstrap-notification/js/bootstrap.notification.js');

        $this->css('faq/assets/faq.css', __FILE__);
        $this->css('faq/assets/jquery-ui.min.css', __FILE__);
        $this->js('faq/assets/bootbox.min.js', __FILE__);
        $this->js('includes/common/plugin/assets/base.js');
        $this->js('faq/assets/faq.js?', __FILE__);
        require_once abs_plugin_path(__FILE__) . '/faq/index.php';
    }

    //Public
    public function public_init()
    {
        $shortcode = Pf::shortcode();
        $shortcode->add('faq', array($this, 'plugin_faq_public'));
    }

    function plugin_faq_public($atts, $content = null, $code = ''){
        $output = require abs_plugin_path(__FILE__) . '/faq/public/index.php';
        return $output;
    }

}
